<?php
require_once '../../core/init.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: ../../auth/admin/login.php");
    exit;
}

$agents = $conn->query("SELECT * FROM submerchants ORDER BY created_at DESC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Merchants | Swirl</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    .clickable-row {
      transition: background 0.2s ease;
    }
    .clickable-row:hover {
      background-color: #f9fafb;
      cursor: pointer;
    }
  </style>
</head>
<body class="bg-gray-50 text-gray-800">
  <div class="flex min-h-screen">

    <!-- Sidebar -->
    <?php require_once 'sidebar.php'; ?>

    <!-- Main Content -->
    <main class="ml-64 flex-1 p-8">
      <div class="flex justify-between items-center mb-6">
        <div>
          <h2 class="text-2xl font-bold">Merchants</h2>
          <p class="text-sm text-gray-500">All onboarded submerchants and agents</p>
        </div>
      </div>

      <div class="bg-white shadow rounded-xl p-6 overflow-x-auto">
        <table class="w-full text-sm">
          <thead class="bg-gray-100 text-gray-600">
            <tr>
              <th class="p-3 text-left">Name</th>
              <th class="p-3 text-left">Email</th>
              <th class="p-3 text-left">Fee %</th>
              <th class="p-3 text-left">Bank</th>
              <th class="p-3 text-left">Account Number</th>
              <th class="p-3 text-left">Account Holder</th>
              <th class="p-3 text-left">Created</th>
            </tr>
          </thead>
          <tbody>
            <?php if ($agents && $agents->num_rows > 0): ?>
              <?php while ($a = $agents->fetch_assoc()): ?>
                <tr class="border-t clickable-row" onclick="window.location.href='merchant.php?id=<?= $a['id'] ?>'">
                  <td class="p-3"><?= htmlspecialchars($a['name']) ?></td>
                  <td class="p-3"><?= htmlspecialchars($a['email']) ?></td>
                  <td class="p-3"><?= number_format($a['fee_percent'], 2) ?>%</td>
                  <td class="p-3"><?= htmlspecialchars($a['bank_name']) ?></td>
                  <td class="p-3"><?= htmlspecialchars($a['account_number']) ?></td>
                  <td class="p-3"><?= htmlspecialchars($a['account_holder']) ?></td>
                  <td class="p-3 text-xs text-gray-500"><?= $a['created_at'] ?? '-' ?></td>
                </tr>
              <?php endwhile; ?>
            <?php else: ?>
              <tr>
                <td colspan="7" class="p-6 text-center text-gray-400 italic">No merchants found.</td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </main>

  </div>
</body>
</html>
