<!-- transaction_scripts.php -->

<!-- Full Transaction Modal -->
<div id="fullTxnModal" class="hidden fixed inset-0 bg-black bg-opacity-50 flex justify-center items-center z-50">
  <div class="modal-content">
    <textarea id="modalTextarea" class="w-full h-80 p-4 border rounded-md text-sm mb-4"></textarea>
    <div class="flex justify-end gap-2">
      <button onclick="copyModalContent()" class="bg-purple-600 hover:bg-purple-700 text-white font-semibold text-sm px-5 py-2 rounded-full transition-all">Copy</button>
      <button onclick="closeModal()" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-semibold text-sm px-5 py-2 rounded-full transition-all">Close</button>
    </div>
  </div>
</div>

<style>
  /* 🟣 Modal Content Styling */
  #fullTxnModal .modal-content {
    background: white;
    padding: 24px;
    border-radius: 12px;
    width: 95%;
    max-width: 900px;
    max-height: 85vh;
    overflow-y: auto;
  }

  /* 🟣 Toast Notification */
  .toast {
    position: fixed;
    bottom: 30px;
    right: 30px;
    background: #6b21a8;
    color: white;
    padding: 8px 14px;
    border-radius: 8px;
    font-size: 14px;
    animation: fadeout 2s forwards;
    z-index: 100;
  }

  @keyframes fadeout {
    0% { opacity: 1; }
    80% { opacity: 1; }
    100% { opacity: 0; transform: translateY(20px); }
  }
</style>

<script>
// ✅ Copy single text value
function copyText(text) {
  const tempTextarea = document.createElement('textarea');
  tempTextarea.value = text;
  document.body.appendChild(tempTextarea);
  tempTextarea.select();
  document.execCommand('copy');
  document.body.removeChild(tempTextarea);
  showToast('Copied!');
}

// ✅ Open modal with full transaction JSON
function openFullModal(json) {
  const modal = document.getElementById('fullTxnModal');
  const textarea = document.getElementById('modalTextarea');
  textarea.value = json;
  modal.style.display = 'flex';
}

// ✅ Copy modal textarea content
function copyModalContent() {
  const textarea = document.getElementById('modalTextarea');
  textarea.select();
  document.execCommand('copy');
  showToast('Full transaction copied!');
}

// ✅ Close modal
function closeModal() {
  document.getElementById('fullTxnModal').style.display = 'none';
}

// ✅ Show toast notification
function showToast(message) {
  const toast = document.createElement('div');
  toast.className = "toast";
  toast.innerText = message;
  document.body.appendChild(toast);
  setTimeout(() => {
    toast.remove();
  }, 2000);
}

// ✅ Search filter
document.getElementById('searchBox').addEventListener('input', function () {
  const filter = this.value.toLowerCase();
  const rows = document.querySelectorAll('#txnBody tr');
  rows.forEach(row => {
    row.style.display = row.innerText.toLowerCase().includes(filter) ? '' : 'none';
  });
});

// ✅ Export to CSV
function exportToCSV() {
  let csv = "Agent,Date,Amount,Type,Status,Card,RRN,Acquirer,Device,Input,Lat/Lng,Txn ID\n";
  document.querySelectorAll('#txnBody tr').forEach(row => {
    const cols = row.querySelectorAll('td');
    if (cols.length >= 12) {
      const data = [
        cols[0].innerText.trim(),
        cols[1].innerText.trim(),
        cols[2].innerText.trim(),
        cols[3].innerText.trim(),
        cols[4].innerText.trim(),
        cols[5].innerText.trim(),
        cols[6].innerText.trim(),
        cols[7].innerText.trim(),
        cols[8].innerText.trim(),
        cols[9].innerText.trim(),
        cols[10].innerText.trim(),
        cols[11].innerText.trim()
      ];
      csv += data.map(x => `"${x.replace(/"/g, '""')}"`).join(",") + "\n";
    }
  });

  const blob = new Blob([csv], { type: 'text/csv;charset=utf-8;' });
  const link = document.createElement('a');
  link.href = URL.createObjectURL(blob);
  link.download = 'transactions.csv';
  link.click();
}
</script>
