<?php
require_once 'config.php';
require_once 'CycleAPI.php';

$api = new CycleAPI();

$from = $_GET['from'] ?? date('Y-m-d', strtotime('-2 days'));
$to = $_GET['to'] ?? date('Y-m-d');
$selectedAgent = $_GET['agent'] ?? '';

$agents = file_exists("agents.json") ? json_decode(file_get_contents("agents.json"), true) : [];

$transactions = $api->getClientTransactions($from, $to);

$agentMap = [];
foreach ($agents as $a) {
    $agentMap[$a['AgentID']] = $a['Name'];
}

if (!empty($selectedAgent)) {
    $transactions = array_filter($transactions, function ($tx) use ($selectedAgent) {
        return isset($tx['PosID']) && $tx['PosID'] == $selectedAgent;
    });
}

function formatAmount($amount) {
    return 'R' . number_format($amount, 2);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Transaction History</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-100 text-gray-900">
    <div class="max-w-7xl mx-auto px-4 py-6">
        <div class="flex items-center justify-between mb-6">
            <h1 class="text-2xl font-bold text-purple-700 flex items-center">
                <img src="https://img.icons8.com/ios-filled/24/receipt-approved.png" class="mr-2"> Transaction History
            </h1>
            <a href="admin.php" class="text-purple-600 hover:underline text-sm">← Back to Dashboard</a>
        </div>

        <form method="GET" class="flex items-center gap-4 mb-6">
            <input type="date" name="from" value="<?= $from ?>" class="border px-3 py-2 rounded shadow-sm" required>
            <input type="date" name="to" value="<?= $to ?>" class="border px-3 py-2 rounded shadow-sm" required>
            <select name="agent" class="border px-3 py-2 rounded shadow-sm">
                <option value="">All Agents</option>
                <?php foreach ($agents as $agent): ?>
                    <option value="<?= $agent['AgentID'] ?>" <?= $selectedAgent == $agent['AgentID'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($agent['Name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
            <button type="submit" class="bg-purple-600 text-white px-4 py-2 rounded hover:bg-purple-700">Filter</button>
        </form>

        <div class="bg-white shadow rounded p-4 overflow-x-auto">
            <h2 class="text-lg font-semibold mb-4">Results</h2>
            <table class="min-w-full text-sm text-left">
                <thead class="bg-gray-100 border-b">
                    <tr>
                        <th class="px-4 py-2 font-semibold">Agent</th>
                        <th class="px-4 py-2 font-semibold">Date</th>
                        <th class="px-4 py-2 font-semibold">Amount</th>
                        <th class="px-4 py-2 font-semibold">Type</th>
                        <th class="px-4 py-2 font-semibold">Status</th>
                        <th class="px-4 py-2 font-semibold">Card</th>
                        <th class="px-4 py-2 font-semibold">RRN</th>
                        <th class="px-4 py-2 font-semibold">Acquirer Code</th>
                        <th class="px-4 py-2 font-semibold">Acquirer Name</th>
                        <th class="px-4 py-2 font-semibold">Payment Icon</th>
                        <th class="px-4 py-2 font-semibold">Device</th>
                        <th class="px-4 py-2 font-semibold">Input</th>
                        <th class="px-4 py-2 font-semibold">Lat/Lng</th>
                        <th class="px-4 py-2 font-semibold">Txn ID</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($transactions)): ?>
                        <tr>
                            <td colspan="14" class="text-center italic text-gray-500 px-4 py-6">
                                No transactions found for this period.
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($transactions as $tx): ?>
                            <tr class="border-b hover:bg-gray-50">
                                <td class="px-4 py-2"> <?= $agentMap[$tx['PosID']] ?? 'Unknown' ?> </td>
                                <td class="px-4 py-2"> <?= date('Y-m-d H:i', strtotime($tx['Date'])) ?> </td>
                                <td class="px-4 py-2"> <?= formatAmount($tx['Amount']) ?> </td>
                                <td class="px-4 py-2"> <?= $tx['Operation'] ?? '-' ?> </td>
                                <td class="px-4 py-2"> <?= $tx['StateDisplay'] ?? '-' ?> </td>
                                <td class="px-4 py-2"> <?= $tx['Card']['PANMasked'] ?? 'Cash' ?> </td>
                                <td class="px-4 py-2"> <?= $tx['RRN'] ?? '-' ?> </td>
                                <td class="px-4 py-2"> <?= $tx['AcquirerCode'] ?? '-' ?> </td>
                                <td class="px-4 py-2"> <?= $tx['AcquirerName'] ?? '-' ?> </td>
                                <td class="px-4 py-2">
                                    <?php if (!empty($tx['ImgUrl'])): ?>
                                        <img src="<?= $tx['ImgUrl'] ?>" alt="Icon" class="h-6">
                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>
                                <td class="px-4 py-2"> <?= $tx['DeviceInfo']['DeviceID'] ?? '-' ?> (<?= $tx['DeviceInfo']['DeviceType'] ?? '-' ?>) </td>
                                <td class="px-4 py-2"> <?= $tx['InputType'] ?? '-' ?> </td>
                                <td class="px-4 py-2"> <?= ($tx['Location']['Latitude'] ?? '-') . ',' . ($tx['Location']['Longitude'] ?? '-') ?> </td>
                                <td class="px-4 py-2 text-xs"> <?= $tx['ID'] ?> </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</body>
</html>
