<?php
require_once 'config.php';

session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) {
    die("DB Connection Failed: " . $conn->connect_error);
}

$agents = $conn->query("SELECT * FROM submerchants ORDER BY created_at DESC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Merchants | Swirl</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    .clickable-row {
      transition: background 0.2s ease;
    }
    .clickable-row:hover {
      background-color: #f9fafb;
      cursor: pointer;
    }
  </style>
</head>
<body class="bg-gray-50 text-gray-800">
  <div class="flex min-h-screen">
    <!-- Sidebar -->
    <aside class="w-64 bg-white border-r p-6">
      <div class="flex items-center gap-3 mb-8">
        <div class="w-10 h-10 bg-purple-600 rounded-full flex items-center justify-center text-white font-bold">S</div>
        <div>
          <h1 class="font-bold text-lg">Swirl</h1>
          <p class="text-xs text-gray-400">Admin Panel</p>
        </div>
      </div>
      <nav class="space-y-4 text-sm">
        <a href="admin.php" class="block hover:text-purple-600">📊 Dashboard</a>
        <a href="history.php" class="block hover:text-purple-600">🧾 Transactions</a>
        <a href="settlements.php" class="block hover:text-purple-600">🏦 Settlements</a>
        <a href="merchants.php" class="block font-semibold text-purple-700">👥 Merchants</a>
        <a href="logout.php" class="block text-red-500">Logout</a>
      </nav>
    </aside>

    <!-- Main Content -->
    <main class="flex-1 p-8">
      <div class="flex justify-between items-center mb-6">
        <div>
          <h2 class="text-2xl font-bold">Merchants</h2>
          <p class="text-sm text-gray-500">All onboarded submerchants and agents</p>
        </div>
      </div>

      <div class="bg-white shadow rounded-xl p-6">
        <table class="w-full text-sm">
          <thead class="bg-gray-100 text-gray-600">
            <tr>
              <th class="p-3 text-left">Name</th>
              <th class="p-3 text-left">Email</th>
              <th class="p-3 text-left">Fee %</th>
              <th class="p-3 text-left">Bank</th>
              <th class="p-3 text-left">Account Number</th>
              <th class="p-3 text-left">Account Holder</th>
              <th class="p-3 text-left">Created</th>
            </tr>
          </thead>
          <tbody>
            <?php if ($agents && $agents->num_rows > 0): ?>
              <?php while ($a = $agents->fetch_assoc()): ?>
                <tr class="border-t clickable-row" onclick="window.location.href='merchant.php?id=<?= $a['id'] ?>'">
                  <td class="p-3"><?= htmlspecialchars($a['name']) ?></td>
                  <td class="p-3"><?= htmlspecialchars($a['email']) ?></td>
                  <td class="p-3"><?= number_format($a['fee_percent'], 2) ?>%</td>
                  <td class="p-3"><?= htmlspecialchars($a['bank_name']) ?></td>
                  <td class="p-3"><?= htmlspecialchars($a['account_number']) ?></td>
                  <td class="p-3"><?= htmlspecialchars($a['account_holder']) ?></td>
                  <td class="p-3 text-xs text-gray-500"><?= $a['created_at'] ?? '-' ?></td>
                </tr>
              <?php endwhile; ?>
            <?php else: ?>
              <tr>
                <td colspan="7" class="p-6 text-center text-gray-400 italic">No merchants found.</td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </main>
  </div>
</body>
</html>
