<!-- Sidebar Toggle Script -->
<script>
  function toggleSidebar() {
    const sidebar = document.getElementById('mobileSidebar');
    sidebar.classList.toggle('-translate-x-full');
  }
</script>

<!-- Mobile Menu Button -->
<div class="md:hidden flex items-center justify-between bg-[#0f172a] text-white p-4 sticky top-0 z-50">
  <h1 class="text-xl font-bold text-purple-400">Swirl</h1>
  <button onclick="toggleSidebar()" class="focus:outline-none text-white">
    ☰
  </button>
</div>

<!-- Mobile Sidebar -->
<div id="mobileSidebar" class="fixed top-0 left-0 w-64 bg-[#0f172a] text-white transform -translate-x-full transition-transform duration-300 ease-in-out md:hidden h-full z-40">
  <div class="p-6 flex flex-col h-full justify-between">
    <div>
      <h2 class="text-2xl font-bold mb-6 text-purple-400">Swirl</h2>
      <nav class="space-y-4">
        <a href="admin.php" class="block hover:text-purple-300">📊 Dashboard</a>
        <a href="history.php" class="block hover:text-purple-300">🧾 Transactions</a>
        <a href="settlements.php" class="block hover:text-purple-300">💰 Settlements</a>
        <a href="agents.php" class="block hover:text-purple-300">🧑‍💼 Submerchants</a>
        <a href="settings.php" class="block hover:text-purple-300">⚙️ Settings</a>
      </nav>
    </div>
    <div>
      <a href="logout.php" class="text-gray-400 hover:text-red-500">🚪 Logout</a>
    </div>
  </div>
</div>

<!-- Desktop Sidebar -->
<aside class="hidden md:flex w-64 bg-[#0f172a] text-white p-6 flex-col justify-between min-h-screen">
  <div>
    <h2 class="text-2xl font-bold mb-6 text-purple-400">Swirl</h2>
    <nav class="space-y-4">
      <a href="admin.php" class="flex items-center gap-2 hover:text-purple-300 text-sm">📊 Dashboard</a>
      <a href="history.php" class="flex items-center gap-2 hover:text-purple-300 text-sm">🧾 Transactions</a>
      <a href="settlements.php" class="flex items-center gap-2 hover:text-purple-300 text-sm">💰 Settlements</a>
      <a href="agents.php" class="flex items-center gap-2 hover:text-purple-300 text-sm">🧑‍💼 Submerchants</a>
      <a href="settings.php" class="flex items-center gap-2 hover:text-purple-300 text-sm">⚙️ Settings</a>
    </nav>
  </div>
  <div class="mt-10">
    <a href="logout.php" class="text-gray-400 hover:text-red-500 text-sm">🚪 Logout</a>
  </div>
</aside>
