<?php
require_once 'config.php';
session_start();

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) die("DB Connection Failed");

$user = $_SESSION['name'] ?? 'Unknown Admin';
$merchantId = intval($_POST['merchant_id'] ?? 0);

if ($merchantId === 0) {
    header("Location: merchants.php");
    exit;
}

$result = $conn->query("SELECT * FROM submerchants WHERE id = $merchantId");
$currentData = $result->fetch_assoc();

$updates = [];
foreach ($_POST as $field => $value) {
    if (!in_array($field, ['merchant_id']) && isset($currentData[$field])) {
        $oldValue = $currentData[$field];
        if ($oldValue != $value) {
            $safeField = $conn->real_escape_string($field);
            $safeValue = $conn->real_escape_string($value);
            $updates[] = "$safeField = '$safeValue'";

            // Log to audit table
            $stmt = $conn->prepare("INSERT INTO merchant_audit_log (merchant_id, field_changed, old_value, new_value, updated_by) VALUES (?, ?, ?, ?, ?)");
            $stmt->bind_param("issss", $merchantId, $field, $oldValue, $value, $user);
            $stmt->execute();
        }
    }
}

if (!empty($updates)) {
    $sql = "UPDATE submerchants SET " . implode(', ', $updates) . " WHERE id = $merchantId";
    $conn->query($sql);
}

header("Location: merchant.php?id=$merchantId&updated=1");
exit;
